<?php
/**
* Getting Started
* 
* @package cf7skins
* @author Neil Murray
* @since 1.2
*/
?>
<div class="cf7s-info">
<h2><?php _e( 'Quick Start Guide', CF7SKINS_TEXTDOMAIN ); ?></h2>
<img src="<?php echo CF7SKINS_URL; ?>images/cf7skins-forms.jpg" alt="cf7skins-forms" width="400" height="320" class="alignright" /><p><a href="http://cf7skins.com"  target="_blank"><strong>CF7 Skins</strong></a> <?php _e( 'makes it easier for regular WordPress users to create Contact Form 7 forms using built in <strong>Templates</strong> and <strong>Styles</strong>.', CF7SKINS_TEXTDOMAIN ); ?></p>

<p><?php _e( 'Simply select from a list of compatible <strong>Templates</strong> that cover many common forms and then choose from a range of professional and beautiful <strong>Styles</strong>.', CF7SKINS_TEXTDOMAIN ); ?> </p>

<p><?php _e( 'Each <strong>Template</strong> acts as an easy to follow guide, which can be adapted to your particular requirements.', CF7SKINS_TEXTDOMAIN ); ?> <?php _e( 'Every <strong>Style</strong> covers the full range of Contact Form 7 form elements.', CF7SKINS_TEXTDOMAIN ); ?></p>

<h3><?php _e( 'Using CF7 Skins', CF7SKINS_TEXTDOMAIN ); ?></h3>
<p><?php _e( 'CF7 Skins appears in an extra <strong>Skins</strong> section in the Contact Form 7 form interface. Click on <strong>Contact</strong> in the WordPress admin menu and select an existing Contact Form 7 form or create a new one, then scroll down to the <strong>Skins</strong> section.', CF7SKINS_TEXTDOMAIN ); ?></p>

<p><?php _e( 'The <strong>Template</strong> tab displays the available templates. Click on <strong>Details</strong> below each template to show more information. Click on <strong>Select</strong> to apply this template in the Form editing area, where you can adjust the fields to match your requirements.', CF7SKINS_TEXTDOMAIN ); ?></p>

<p><?php _e( 'Click on the <strong>Style</strong> tab to view the list of available styles to choose from. <strong>Details</strong> below each style gives more information about each style. Find a style that you like and click <strong>Select</strong>. Then press <strong>Save</strong> to apply the style to your form.', CF7SKINS_TEXTDOMAIN ); ?></p>

<h3><?php _e( 'Doing more with CF7 Skins', CF7SKINS_TEXTDOMAIN ); ?></h3>
<img src="<?php echo CF7SKINS_URL; ?>images/using-cf7skins.jpg" alt="cf7skins-forms" width="400" height="200" class="alignright" /><p><?php _e( 'The CF7 Skins Knowledge Base can help you get more out of using CF7 Skins with your Contact Form 7 forms.', CF7SKINS_TEXTDOMAIN ); ?></p>

<ul>
	<li>
	<a href="http://kb.cf7skins.com/understanding-templates-and-styles/"  target="_blank"><?php _e( 'Understanding Templates and Styles', CF7SKINS_TEXTDOMAIN ); ?></a>
	</li>
	<li>
	<a href="http://kb.cf7skins.com/why-we-use-fieldset-legend-lists-in-cf7-skins/"  target="_blank"><?php _e( 'Fieldset, Legend & Lists in CF7 Skins', CF7SKINS_TEXTDOMAIN ); ?></a>
	</li>
	<li>
	<a href="http://kb.cf7skins.com/edit-your-cf7-skins-form/"  target="_blank"><?php _e( 'Edit your CF7 Skins Form', CF7SKINS_TEXTDOMAIN ); ?></a>
	</li>
	<li>
	<a href="http://kb.cf7skins.com/use-custom-css-plugin/"  target="_blank"><?php _e( 'Modify your CF7 Skins Style', CF7SKINS_TEXTDOMAIN ); ?></a>
	</li>
</ul>

<p><a class="cf7s-btn" target="_blank" href="http://kb.cf7skins.com/category/using-cf7skins/"><?php _e( 'Learn More', CF7SKINS_TEXTDOMAIN ); ?></a></p>

<h3><?php _e( 'Documentation', CF7SKINS_TEXTDOMAIN ); ?></h3>
<img src="<?php echo CF7SKINS_URL; ?>images/cf7skins-solution.jpg" alt="cf7skins-forms" width="400" height="200" class="alignright size-medium wp-image-2919" /><p><?php _e( 'Our in-depth documentation is a great place to find detailed answers.', CF7SKINS_TEXTDOMAIN ); ?></p>

<ul>
	<li>
	<strong><a href="http://docs.cf7skins.com/"  target="_blank"><?php _e( 'Documentation', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'covers from how to get started up to how to customize your forms and everything else in between.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
	<strong><a href="http://kb.cf7skins.com/"  target="_blank"><?php _e( 'Knowledge Base', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'you can search by Categories & Tags or Keywords.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
	<strong><a href="http://kb.cf7skins.com/category/tutorials/"  target="_blank"><?php _e( 'Tutorials', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'to help you get started using CF7 Skins quickly & easily.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
</ul>

<p><a href="http://cf7skins.com"  target="_blank"><?php _e( 'Plugin Website', CF7SKINS_TEXTDOMAIN ); ?></a> | <a href="http://cf7skins.com/pro-version/"  target="_blank"><?php _e( 'Pro Version', CF7SKINS_TEXTDOMAIN ); ?></a> | <a href="http://cf7skins.com/add-ons/"  target="_blank"><?php _e( 'Add-ons', CF7SKINS_TEXTDOMAIN ); ?></a></p>

<p><a href="http://kb.cf7skins.com/faq/"  target="_blank"><?php _e( 'FAQ', CF7SKINS_TEXTDOMAIN ); ?></a> | <a href="http://docs.cf7skins.com/"  target="_blank"><?php _e( 'Documentation', CF7SKINS_TEXTDOMAIN ); ?></a> | <a href="http://kb.cf7skins.com/category/tutorials/"  target="_blank"><?php _e( 'Tutorials', CF7SKINS_TEXTDOMAIN ); ?></a> | <a href="http://kb.cf7skins.com/"  target="_blank"><?php _e( 'Knowledge Base', CF7SKINS_TEXTDOMAIN ); ?></a></p>
</div>

<div class="cf7s-info-sidebar">
<h2><?php _e( 'Do you enjoy using this plugin?', CF7SKINS_TEXTDOMAIN ); ?></h2>
<p><?php _e( 'You can help fellow WordPress users in the following simple ways:', CF7SKINS_TEXTDOMAIN ); ?></p>
<ul>
	<li>
	<strong><a href="https://wordpress.org/support/view/plugin-reviews/contact-form-7-skins"  target="_blank"><?php _e( 'Review', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'leave a  plugin review on WordPress.org', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
	<strong><a href="http://cf7skins.com/pro-version/testimonials/"  target="_blank"><?php _e( 'Testimonial', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'add your Testimonial to those listed', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
	<strong><a href="https://wordpress.org/plugins/contact-form-7-skins/"  target="_blank"><?php _e( 'Compatibility', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'log in & vote "works" on your current versions', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
	<strong><a href="http://cf7skins.com/support/#feedback"  target="_blank"><?php _e( 'Feedback', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'help us to improve CF7 Skins by offering feedback', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
</ul>

<h2><?php _e( 'Need some help?', CF7SKINS_TEXTDOMAIN ); ?></h2>
<p><?php _e( 'You have a number of options to help you use CF7 Skins:', CF7SKINS_TEXTDOMAIN ); ?></p>
<ul>
	<li>
	<strong><a href="http://kb.cf7skins.com/faq/"  target="_blank"><?php _e( 'FAQ', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'browse over some commonly asked questions.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
	<strong><a href="http://docs.cf7skins.com/"  target="_blank"><?php _e( 'Documentation', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'a great place to find detailed answers.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
	<strong><a href="http://kb.cf7skins.com/"  target="_blank"><?php _e( 'Knowledge Base', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'search by Categories & Tags or Keywords.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
	<strong><a href="http://kb.cf7skins.com/category/tutorials/"  target="_blank"><?php _e( 'Tutorials', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'to help you get started quickly with CF7 Skins.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li><strong><?php _e( 'Free Version', CF7SKINS_TEXTDOMAIN ); ?></strong></li>
	<ul>
		<li>
		<strong><a href="https://wordpress.org/support/plugin/contact-form-7-skins"  target="_blank"><?php _e( 'WordPress.org Support Forum', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'community based support offered by other CF7 Skin users (we visit the forum intermittently to assist with plugin bugs only).', CF7SKINS_TEXTDOMAIN ); ?>
		</li>
	</ul>
	<li><strong><?php _e( 'Pro Version & Add-ons', CF7SKINS_TEXTDOMAIN ); ?></strong></li>
	<ul>
		<li>
		<strong><a href="http://cf7skins.com/support/#premium-email-support"  target="_blank"><?php _e( 'Premium Email Support', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'available (for current paid licenses) to deal with CF7 Skins Pro users questions and problems.', CF7SKINS_TEXTDOMAIN ); ?>
		</li>
	</ul>
</ul>
<p><a href="http://cf7skins.com"  target="_blank"><?php _e( 'Plugin Website', CF7SKINS_TEXTDOMAIN ); ?></a> | <a href="http://cf7skins.com/pro-version/"  target="_blank"><?php _e( 'Pro Version', CF7SKINS_TEXTDOMAIN ); ?></a> | <a href="http://cf7skins.com/add-ons/"  target="_blank"><?php _e( 'Add-ons', CF7SKINS_TEXTDOMAIN ); ?></a></p>

<p><a href="http://kb.cf7skins.com/faq/"  target="_blank"><?php _e( 'FAQ', CF7SKINS_TEXTDOMAIN ); ?></a> | <a href="http://docs.cf7skins.com/"  target="_blank"><?php _e( 'Documentation', CF7SKINS_TEXTDOMAIN ); ?></a> | <a href="http://kb.cf7skins.com/category/tutorials/"  target="_blank"><?php _e( 'Tutorials', CF7SKINS_TEXTDOMAIN ); ?></a> | <a href="http://kb.cf7skins.com/"  target="_blank"><?php _e( 'Knowledge Base', CF7SKINS_TEXTDOMAIN ); ?></a></p>
</div>